Imports System.Text.Encoding


Module General
    '
    'Version 1.1
    'EEB
    '

    Const port As Int16 = 1394
    Public KI2701Client As New System.Net.Sockets.TcpClient()
    Public KI2701Stream As System.Net.Sockets.NetworkStream
    Public KIstatus As String
    Public connected As Boolean = False
    Public ip As String = "192.168.1.10"
    Public KIByte As Byte()
    Public KIData As String
    Public front As Boolean = False
    '   Public KIInput As String

    Dim dis As Boolean = False


    Public Sub send(ByVal KIData As String)

        KI2701Stream = KI2701Client.GetStream()
        KIData = KIData + vbCr                           ' Add control reset to the command line
        KIByte = ASCII.GetBytes(KIData)                 ' Convert to byte
        KI2701Stream.Write(KIByte, 0, KIData.Length)    ' Send data
    End Sub

    Public Sub connect(ByVal ip As String)
        Dim zz As Object
        Dim z As Object

       
        Try

            KI2701Client.Connect(ip, port)
            KI2701Stream = KI2701Client.GetStream
            If KI2701Stream.CanWrite And KI2701Stream.CanRead Then
                connected = True
            Else
                connected = False
            End If
        Catch e As Exception

            Dim errnum As New System.Net.Sockets.SocketException() '.ErrorCode()
            Dim aa As String
         
            Select Case errnum.ErrorCode

                Case Is = 10060
                    MessageBox.Show("Could not connect to the 2701, please recheck your connections and network settings and try again ", "Time Out Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
                Case Is = 10061
                    MessageBox.Show("Could not open connection because instrument has an open connection to another application.  Close the connected application or power cycle the instrument to close existing connection", "Connection Refused !", MessageBoxButtons.OK, MessageBoxIcon.Error)
                Case Else
                    MessageBox.Show("Error has occured:  " & errnum.ErrorCode & "  " & e.Message, "Error has been detected !", MessageBoxButtons.OK, MessageBoxIcon.Error)
            End Select



        End Try
    End Sub
 
    Public Sub disconnect()
        If connected = True Then
            send("*rst")
            connected = False

            KI2701Stream.Close()
            KI2701Client.Close()
            KI2701Client = Nothing
            dis = True
        End If
        connected = False
    End Sub
    Public Sub KI2701send(ByVal data As String)
        'Send data
        Dim senddata As Byte

    End Sub
    Public Sub KIInput(Byref KIstatus as String)
        send("SYST:FRSW?")
        KI2701Read(KIData)
        If KIData = 1 Then
            KIstatus = "Front"
        Else
            KIstatus = "Rear"
        End If

    End Sub
    Public Sub KI2701Read(ByRef KIdata As String)


        ' Read network stream into byte buffer
        Dim bytes(KI2701Client.ReceiveBufferSize) As Byte
        KI2701Stream.Read(bytes, 0, KI2701Client.ReceiveBufferSize)
        KIdata = ASCII.GetString(bytes)
        ' Debug.WriteLine(KIdata)
    End Sub


End Module
